#pragma once

#include <vector>
#include <bitset>

#include "EntityId.h"
#include "ComponentPool.h"

class ComponentSystemBase
{
public:

	void AddEntity(EntityId entityId);
	void RemoveEntity(EntityId entityId);
	bool HasEntity(EntityId entityId);

	virtual void Update(float deltaSeconds) { };

	const std::bitset<32>& GetRequiredComponents() const 
	{ 
		return m_requiredComponents; 
	}

protected:

	template <typename ComponentType>
	void AddRequiredComponent()
	{
		int componentId = DataComponent<ComponentType>::GetId();
		m_requiredComponents.set(componentId, true);
	}

	std::bitset<32> m_requiredComponents;
	std::vector<EntityId> m_registeredEntities;
};